"""Simple program to demo how to use meshtastic library.
   To run: python examples/info.py
"""

import meshtastic
import meshtastic.serial_interface
import json
import base64
from meshtastic.util import fromPSK
import os
from meshtastic.protobuf import channel_pb2

interface = meshtastic.serial_interface.SerialInterface()

node = interface.getNode('^local')
channels = node.channels

if channels:
    print("Channels:")
    for channel in channels:
        if channel.role:
            psk_base64 = base64.b64encode(channel.settings.psk).decode('utf-8')
            print(f"Index: {channel.index}, Role: {channel.role}, PSK (Base64): {psk_base64}, Name: {channel.settings.name}")
            print(channel.settings)

ch = node.channels[0]
ch.settings.psk = os.urandom(32)
#ch.settings.uplink_enabled = False
#ch.settings.downlink_enabled = False
#32 is precise location
#19 - 150 ft  45 m
#18 - 300 ft  95 m
#17 - 600 ft  190 m
#16 - 1200 ft 375 m
#15 - 2400 ft 750 m
#14 - 4800 ft 1.5 km
#13 - 1.8 mi  3 km
#12 - 3.6 mi  6 km
#11 - 7.3 mi  12 km
#10 - 14.5 mi 24 km
#ch.settings.module_settings.position_precision = 32
ch.settings.name = "difet"
ch.role = channel_pb2.Channel.Role.PRIMARY
node.writeChannel(0)

if channels:
    print("Channels:")
    for channel in channels:
        if channel.role:
            psk_base64 = base64.b64encode(channel.settings.psk).decode('utf-8')
            print(channel.settings)
            print(f"Index: {channel.index}, Role: {channel.role}, PSK (Base64): {psk_base64}, Name: {channel.settings.name}")

interface.close()
